<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// Security: Only Admins can access
if ($_SESSION['role'] !== 'Admin') {
    header("Location: dashboard.php"); exit();
}

// Default values for "Add" mode
$user = ['user_id' => '', 'full_name' => '', 'username' => '', 'role' => 'Accountant'];
$form_action = 'add';
$page_title = 'Create New User';
$password_required = 'required';

// Check for "Edit" mode
if (isset($_GET['id'])) {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE user_id = ?");
    $stmt->execute([$_GET['id']]);
    $user = $stmt->fetch();
    $form_action = 'edit';
    $page_title = 'Edit User';
    $password_required = ''; // Password is not required for editing
}
?>

<div class="content-header">
    <h1><?php echo $page_title; ?></h1>
    <a href="users.php" class="btn">⬅️ Back to User List</a>
</div>

<div class="card">
    <div class="card-body">
        <form action="process_user.php" method="POST">
            <input type="hidden" name="action" value="<?php echo $form_action; ?>">
            <input type="hidden" name="user_id" value="<?php echo $user['user_id']; ?>">

            <div class="form-row">
                <div class="form-group"><label for="full_name">Full Name</label><input type="text" name="full_name" value="<?php echo htmlspecialchars($user['full_name']); ?>" required></div>
                <div class="form-group"><label for="username">Username</label><input type="text" name="username" value="<?php echo htmlspecialchars($user['username']); ?>" required></div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="role">Role</label>
                    <select name="role">
                        <option value="Accountant" <?php echo ($user['role'] == 'Accountant') ? 'selected' : ''; ?>>Accountant</option>
                        <option value="Admin" <?php echo ($user['role'] == 'Admin') ? 'selected' : ''; ?>>Admin</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" name="password" <?php echo $password_required; ?>>
                    <?php if ($form_action == 'edit'): ?>
                        <p style="font-size: 0.9rem; color: #6c757d;">(Leave blank to keep the current password)</p>
                    <?php endif; ?>
                </div>
            </div>

            <div class="form-footer">
                <button type="submit" class="btn btn-primary">Save User</button>
            </div>
        </form>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>
