<?php
require_once 'config/database.php';
require_once 'includes/header.php';
?>

<div class="content-header">
    <h1>Assign Monthly Transport Fees</h1>
</div>

<?php if(isset($_GET['success'])): ?><div class="alert alert-success"><?php echo htmlspecialchars($_GET['success']); ?></div><?php endif; ?>
<?php if(isset($_GET['error'])): ?><div class="alert alert-danger"><?php echo htmlspecialchars($_GET['error']); ?></div><?php endif; ?>

<div class="card">
    <div class="card-body">
        <p>This will generate a transport fee due for the selected month for ALL students who have a stoppage assigned to them.</p>
        <form action="process_transport_assignment.php" method="POST" onsubmit="return confirm('Are you sure you want to assign transport fees for this month? This cannot be undone.');">
            <div class="form-row">
                <div class="form-group">
                    <label for="fee_month">Select Month and Year</label>
                    <input type="month" id="fee_month" name="fee_month" value="<?php echo date('Y-m'); ?>" required>
                </div>
                <div class="form-group">
                    <label for="due_date">Due Date for this Fee</label>
                    <input type="date" id="due_date" name="due_date" required>
                </div>
            </div>
            <div class="form-footer">
                <button type="submit" class="btn btn-primary">Assign Transport Fees</button>
            </div>
        </form>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>
