<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// --- Fetch all students from the database ---
try {
    // We use a LEFT JOIN to get the class name and section from the 'classes' table
    $sql = "SELECT s.student_id, s.student_uid, s.full_name, s.guardian_contact, c.class_name, c.section 
            FROM students s
            LEFT JOIN classes c ON s.class_id = c.class_id
            WHERE s.is_active = 1
            ORDER BY s.full_name ASC";
    
    $stmt = $pdo->query($sql);
    $students = $stmt->fetchAll();

} catch (PDOException $e) {
    // In a real app, you'd log this error and show a user-friendly message
    die("Error: Could not fetch students. " . $e->getMessage());
}
?>

<div class="content-header">
    <h1>Student Management</h1>
    <a href="add_student.php" class="btn btn-primary">Add New Student</a>
</div>
<?php if(isset($_GET['success'])): ?>
    <div class="alert alert-success">
        <?php echo htmlspecialchars($_GET['success']); ?>
    </div>
<?php endif; ?>
<?php if(isset($_GET['error'])): ?>
    <div class="alert alert-danger">
        <?php echo htmlspecialchars($_GET['error']); ?>
    </div>
<?php endif; ?>
<div class="card">
    <div class="card-body">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Student UID</th>
                    <th>Full Name</th>
                    <th>Class</th>
                    <th>Guardian Contact</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($students) > 0): ?>
                    <?php foreach ($students as $student): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($student['student_uid']); ?></td>
                            <td><?php echo htmlspecialchars($student['full_name']); ?></td>
                            <td>
                                <?php 
                                    echo htmlspecialchars($student['class_name']) . ' - ' . htmlspecialchars($student['section']); 
                                ?>
                            </td>
                            <td><?php echo htmlspecialchars($student['guardian_contact']); ?></td>
                            <td>
                                <a href="edit_student.php?id=<?php echo $student['student_id']; ?>" class="btn-action btn-edit">Edit</a>
                                <form action="process_student.php" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure you want to deactivate this student? This action cannot be undone from the UI.');">
    <input type="hidden" name="action" value="delete">
    <input type="hidden" name="student_id" value="<?php echo $student['student_id']; ?>">
    <button type="submit" class="btn-action btn-delete">Delete</button>
</form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" style="text-align:center;">No students found. Please add a new student.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>