<?php
require_once 'config/database.php';
require_once 'includes/header.php';

try {
    $stoppages = $pdo->query("SELECT * FROM stoppages ORDER BY stoppage_name ASC")->fetchAll();
} catch (PDOException $e) {
    die("Error: Could not fetch stoppages. " . $e->getMessage());
}
?>

<div class="content-header">
    <h1>Transport Stoppage Management</h1>
    <a href="stoppage_form.php" class="btn btn-primary">Create New Stoppage</a>
</div>

<!-- Message Display Area -->
<?php if(isset($_GET['success'])): ?><div class="alert alert-success"><?php echo htmlspecialchars($_GET['success']); ?></div><?php endif; ?>
<?php if(isset($_GET['error'])): ?><div class="alert alert-danger"><?php echo htmlspecialchars($_GET['error']); ?></div><?php endif; ?>

<div class="card">
    <div class="card-body">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Stoppage Name</th>
                    <th>Monthly Fee (₹)</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($stoppages): ?>
                    <?php foreach ($stoppages as $stoppage): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($stoppage['stoppage_name']); ?></td>
                            <td style="text-align:right;"><?php echo number_format($stoppage['monthly_fee'], 2); ?></td>
                            <td>
                                <a href="stoppage_form.php?id=<?php echo $stoppage['stoppage_id']; ?>" class="btn-action btn-edit">Edit</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="3" style="text-align:center;">No stoppages found. Please create one.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>
