<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// --- Fetch all settings from the database ---
// The query is changed from "SELECT *" to specify the two columns.
$settings_data = $pdo->query("SELECT setting_key, setting_value FROM settings")->fetchAll(PDO::FETCH_KEY_PAIR);

?>

<div class="content-header">
    <h1>System Settings</h1>
</div>

<?php if(isset($_GET['success'])): ?><div class="alert alert-success"><?php echo htmlspecialchars($_GET['success']); ?></div><?php endif; ?>
<?php if(isset($_GET['error'])): ?><div class="alert alert-danger"><?php echo htmlspecialchars($_GET['error']); ?></div><?php endif; ?>

<div class="card">
    <div class="card-body">
        <form action="process_settings.php" method="POST" enctype="multipart/form-data">

            <div class="form-group" style="padding: 0 10px;">
                <label for="school_name">School Name</label>
                <input type="text" id="school_name" name="school_name" value="<?php echo htmlspecialchars($settings_data['school_name'] ?? ''); ?>" required>
            </div>

            <div class="form-group" style="padding: 0 10px;">
                <label for="school_address">School Address</label>
                <textarea id="school_address" name="school_address" rows="3"><?php echo htmlspecialchars($settings_data['school_address'] ?? ''); ?></textarea>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="school_contact">School Contact Info</label>
                    <input type="text" id="school_contact" name="school_contact" value="<?php echo htmlspecialchars($settings_data['school_contact'] ?? ''); ?>" placeholder="Email | Phone">
                </div>
                <div class="form-group">
                    <label for="academic_session">Current Academic Session</label>
                    <input type="text" id="academic_session" name="academic_session" value="<?php echo htmlspecialchars($settings_data['academic_session'] ?? ''); ?>" placeholder="e.g., 2025-2026">
                </div>
            </div>

            <hr>

            <div class="form-group" style="padding: 0 10px;">
                <label for="school_logo">School Logo</label>
                <input type="file" id="school_logo" name="school_logo" accept="image/png, image/jpeg, image/gif">
                <p style="font-size: 0.9rem; color: #6c757d;">(Leave blank to keep the current logo. Recommended size: 200x200px)</p>

                <?php if (!empty($settings_data['school_logo'])): ?>
                    <div style="margin-top:10px;">
                        <strong>Current Logo:</strong><br>
                        <img src="public/images/<?php echo htmlspecialchars($settings_data['school_logo']); ?>" alt="School Logo" style="max-height: 80px; border: 1px solid #ddd; padding: 5px; margin-top: 5px;">
                    </div>
                <?php endif; ?>
            </div>


            <div class="form-footer">
                <button type="submit" class="btn btn-primary">💾 Save Settings</button>
            </div>
        </form>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>