<?php
require_once 'config/database.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || empty($_POST['fee_month']) || empty($_POST['due_date'])) {
    header('Location: transport_fee_assignment.php?error=Month and due date are required.');
    exit();
}

$fee_month_str = $_POST['fee_month']; // e.g., "2025-12"
$due_date = $_POST['due_date'];

$month = date("F Y", strtotime($fee_month_str . "-01"));
$assignment_title = "Transport Fee - " . $month;

try {
    // 1. Find all students with an assigned stoppage
    $sql = "SELECT s.student_id, st.monthly_fee 
            FROM students s
            JOIN stoppages st ON s.stoppage_id = st.stoppage_id
            WHERE s.is_active = 1 AND s.stoppage_id IS NOT NULL";
    
    $students_to_bill = $pdo->query($sql)->fetchAll();

    if (empty($students_to_bill)) {
        throw new Exception("No active students with assigned stoppages were found.");
    }
    
    $pdo->beginTransaction();

    // Prepare the insert statement
    $insert_sql = "INSERT INTO fee_assignments (student_id, assignment_title, amount_due, due_date) VALUES (?, ?, ?, ?)";
    $stmt = $pdo->prepare($insert_sql);
    
    $assignments_created = 0;
    foreach ($students_to_bill as $student) {
        // 2. Check if this fee has already been assigned to this student for this month to prevent duplicates
        $check_sql = "SELECT assignment_id FROM fee_assignments WHERE student_id = ? AND assignment_title = ?";
        $check_stmt = $pdo->prepare($check_sql);
        $check_stmt->execute([$student['student_id'], $assignment_title]);
        
        if ($check_stmt->fetch()) {
            continue; // Skip if already exists
        }

        // 3. Insert the new fee assignment
        $stmt->execute([$student['student_id'], $assignment_title, $student['monthly_fee'], $due_date]);
        $assignments_created++;
    }

    $pdo->commit();

    header("Location: transport_fee_assignment.php?success=$assignments_created transport fee(s) were assigned for $month.");

} catch (Exception $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    header("Location: transport_fee_assignment.php?error=" . urlencode($e->getMessage()));
}
?>
