<?php
require_once 'config/database.php';

// --- ADDED: Redirect Loop Prevention ---
// This safety check prevents the script from running more than once every 2 seconds,
// effectively breaking any potential redirect loops.
if (isset($_SESSION['last_processed']) && (time() - $_SESSION['last_processed'] < 2)) {
    // Unset the variable to allow the next legitimate request after the loop is broken.
    unset($_SESSION['last_processed']); 
    die("Redirect loop detected. Processing has been halted to prevent further errors.");
}
$_SESSION['last_processed'] = time();
// --- END: Redirect Loop Prevention ---


if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['action'])) {
    header('Location: fines.php');
    exit();
}

$action = $_POST['action'];

// The data array now correctly includes 'recurring_period'
$data = [
    'name' => $_POST['fine_name'],
    'fee_head_id' => $_POST['fee_head_id'],
    'days' => $_POST['start_after_days'],
    'type' => $_POST['fine_type'],
    'value' => $_POST['fine_value'],
    'recurring_period' => $_POST['recurring_period'],
    'id' => $_POST['fine_id']
];

try {
    if ($action == 'add') {
        // The SQL INSERT statement now includes the new column
        $sql = "INSERT INTO fines (fine_name, fee_head_id, start_after_days, fine_type, fine_value, recurring_period) 
                VALUES (:name, :fee_head_id, :days, :type, :value, :recurring_period)";
        unset($data['id']);
    } else {
        // The SQL UPDATE statement now includes the new column
        $sql = "UPDATE fines SET 
                    fine_name = :name, 
                    fee_head_id = :fee_head_id, 
                    start_after_days = :days, 
                    fine_type = :type, 
                    fine_value = :value, 
                    recurring_period = :recurring_period 
                WHERE fine_id = :id";
    }
    $pdo->prepare($sql)->execute($data);
    
    // Unset the session variable on successful completion
    unset($_SESSION['last_processed']);
    header("Location: fines.php?success=Fine rule saved successfully!");

} catch (PDOException $e) {
    // Unset the session variable even on error
    unset($_SESSION['last_processed']);
    header("Location: fines.php?error=" . urlencode("Database error: " . $e->getMessage()));
}
exit();
?>

