<?php
require_once 'config/database.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['action'])) {
    header('Location: fee_structures.php');
    exit();
}

$action = $_POST['action'];
// We always need class_id to redirect back to the correct management page
$class_id = $_POST['class_id']; 

try {
    switch ($action) {
        case 'add':
            if (empty($class_id) || empty($_POST['fee_head_id']) || !isset($_POST['amount'])) {
                throw new Exception("Missing required fields.");
            }
            $stmt = $pdo->prepare("INSERT INTO fee_structures (class_id, fee_head_id, amount) VALUES (?, ?, ?)");
            $stmt->execute([$class_id, $_POST['fee_head_id'], $_POST['amount']]);
            header("Location: manage_structure.php?class_id=$class_id&success=Fee component added!");
            break;

        case 'delete':
            if (empty($_POST['structure_id'])) {
                throw new Exception("Invalid structure item selected.");
            }
            $stmt = $pdo->prepare("DELETE FROM fee_structures WHERE structure_id = ?");
            $stmt->execute([$_POST['structure_id']]);
            header("Location: manage_structure.php?class_id=$class_id&success=Fee component removed!");
            break;
    }
} catch (Exception $e) {
    header("Location: manage_structure.php?class_id=$class_id&error=" . urlencode($e->getMessage()));
}
exit();
?>