<?php
require_once 'config/database.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['action'])) {
    header('Location: fee_heads.php');
    exit();
}

$action = $_POST['action'];

try {
    switch ($action) {
        case 'add':
            $stmt = $pdo->prepare("INSERT INTO fee_heads (head_name, description) VALUES (:name, :desc)");
            $stmt->execute([
                'name' => $_POST['head_name'],
                'desc' => $_POST['description']
            ]);
            header("Location: fee_heads.php?success=Fee head created successfully!");
            break;

        case 'edit':
            $stmt = $pdo->prepare("UPDATE fee_heads SET head_name = :name, description = :desc WHERE fee_head_id = :id");
            $stmt->execute([
                'name' => $_POST['head_name'],
                'desc' => $_POST['description'],
                'id' => $_POST['fee_head_id']
            ]);
            header("Location: fee_heads.php?success=Fee head updated successfully!");
            break;

        case 'delete':
            $stmt = $pdo->prepare("DELETE FROM fee_heads WHERE fee_head_id = :id");
            $stmt->execute(['id' => $_POST['fee_head_id']]);
            header("Location: fee_heads.php?success=Fee head deleted successfully!");
            break;
    }
} catch (PDOException $e) {
    if ($e->getCode() == '23000') {
        $error_message = "A fee head with that name already exists.";
    } else {
        $error_message = "Database error: " . $e->getMessage();
    }
    header("Location: fee_heads.php?error=" . urlencode($error_message));
}
exit();
?>