<?php
require_once 'config/database.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: fee_assignment.php');
    exit();
}

// --- Data Validation ---
if (empty($_POST['class_id']) || empty($_POST['student_ids']) || empty($_POST['assignment_title']) || empty($_POST['due_date'])) {
    header('Location: fee_assignment.php?error=Missing required fields. Please select a class, students, and provide assignment details.');
    exit();
}

$class_id = $_POST['class_id'];
$student_ids = $_POST['student_ids'];
$assignment_title = trim($_POST['assignment_title']);
$due_date = $_POST['due_date'];

try {
    // 1. Get the fee structure for the class
    $stmt = $pdo->prepare("SELECT structure_id, amount FROM fee_structures WHERE class_id = ?");
    $stmt->execute([$class_id]);
    $structure_items = $stmt->fetchAll();

    if (empty($structure_items)) {
        throw new Exception("No fee structure is defined for the selected class.");
    }
    
    // 2. Start a transaction
    $pdo->beginTransaction();
    
    // 3. Prepare the insert statement once
    $sql = "INSERT INTO fee_assignments (student_id, structure_id, assignment_title, amount_due, due_date) VALUES (?, ?, ?, ?, ?)";
    $insert_stmt = $pdo->prepare($sql);

    // 4. Loop through each student and each structure item
    foreach ($student_ids as $student_id) {
        foreach ($structure_items as $item) {
            // Check if this specific fee is already assigned to this student for this title to avoid duplicates
            $check_stmt = $pdo->prepare("SELECT assignment_id FROM fee_assignments WHERE student_id = ? AND structure_id = ? AND assignment_title = ?");
            $check_stmt->execute([$student_id, $item['structure_id'], $assignment_title]);
            if ($check_stmt->fetch()) {
                // Skip if already assigned
                continue;
            }

            // Assign the fee
            $insert_stmt->execute([
                $student_id,
                $item['structure_id'],
                $assignment_title,
                $item['amount'],
                $due_date
            ]);
        }
    }

    // 5. If everything is fine, commit the transaction
    $pdo->commit();

    header("Location: fee_assignment.php?success=Fees assigned successfully to " . count($student_ids) . " student(s).");

} catch (Exception $e) {
    // 6. If anything goes wrong, roll back the transaction
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    header("Location: fee_assignment.php?error=" . urlencode("An error occurred: " . $e->getMessage()));
}
exit();
?>