<?php
require_once 'config/database.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['action'])) {
    header('Location: classes.php');
    exit();
}

$action = $_POST['action'];

try {
    switch ($action) {
        case 'add':
            $stmt = $pdo->prepare("INSERT INTO classes (class_name, section) VALUES (:class_name, :section)");
            $stmt->execute([
                'class_name' => $_POST['class_name'],
                'section' => $_POST['section']
            ]);
            header("Location: classes.php?success=Class created successfully!");
            break;

        case 'edit':
            $stmt = $pdo->prepare("UPDATE classes SET class_name = :class_name, section = :section WHERE class_id = :class_id");
            $stmt->execute([
                'class_name' => $_POST['class_name'],
                'section' => $_POST['section'],
                'class_id' => $_POST['class_id']
            ]);
            header("Location: classes.php?success=Class updated successfully!");
            break;

        case 'delete':
            // WARNING: In a real app, first check if students are assigned to this class.
            $stmt = $pdo->prepare("DELETE FROM classes WHERE class_id = :class_id");
            $stmt->execute(['class_id' => $_POST['class_id']]);
            header("Location: classes.php?success=Class deleted successfully!");
            break;
    }
} catch (PDOException $e) {
    // Basic error handling
    if ($e->getCode() == '23000') {
        $error_message = "A class with that name and section already exists.";
    } else {
        $error_message = "Database error: " . $e->getMessage();
    }
    header("Location: classes.php?error=" . urlencode($error_message));
}
exit();
?>