<?php
// Include the database connection file
require_once 'config/database.php';

// Check if the form was submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // --- Data Validation ---
    if (empty(trim($_POST['username'])) || empty(trim($_POST['password']))) {
        // Redirect back to login page with an error
        header("location: index.php?error=Username and password are required.");
        exit();
    }

    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    // --- Prepare and Execute Database Query ---
    try {
        // Prepare a statement to prevent SQL injection
        $sql = "SELECT user_id, username, password_hash, role FROM users WHERE username = :username AND is_active = 1";
        
        $stmt = $pdo->prepare($sql);
        
        // Bind parameters
        $stmt->bindParam(':username', $username, PDO::PARAM_STR);
        
        // Execute the statement
        $stmt->execute();
        
        // Check if a user was found
        if ($stmt->rowCount() == 1) {
            $user = $stmt->fetch();
            
            // Verify the password against the stored hash
            if (password_verify($password, $user['password_hash'])) {
                // Password is correct, start a new session
                session_regenerate_id(true); // Regenerate session ID for security
                
                // Store data in session variables
                $_SESSION['user_id'] = $user['user_id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['role'] = $user['role'];
                
                // Redirect user to the dashboard
                header("location: dashboard.php");
                exit();
                
            } else {
                // Password is not valid
                header("location: index.php?error=Invalid username or password.");
                exit();
            }
        } else {
            // No active user found with that username
            header("location: index.php?error=Invalid username or password.");
            exit();
        }

    } catch (PDOException $e) {
        // Handle database errors
        die("ERROR: Could not execute query. " . $e->getMessage());
    }

    // Close statement and connection (PDO does this automatically when the script ends)
    unset($stmt);
    unset($pdo);

} else {
    // If the script is accessed directly, redirect to login
    header("location: index.php");
    exit();
}
?>