<?php
// This is a protected area. User must be logged in.
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id'])) {
    header('Location: /school-fee-system/index.php'); // Adjust path if needed
    exit();
}

// --- Page Highlighting Logic ---
$currentPage = basename($_SERVER['SCRIPT_NAME']);
$masters_pages = ['classes.php', 'fee_heads.php', 'fines.php', 'fine_form.php', 'stoppages.php', 'stoppage_form.php'];
$fee_management_pages = ['fee_assignment.php', 'bulk_fee_assignment.php', 'transport_fee_assignment.php', 'fee_collection.php'];
$records_pages = ['receipts.php', 'reports.php', 'daily_collection_report.php', 'dues_report.php'];
$communication_pages = ['whatsapp_center.php'];
$system_pages = ['settings.php', 'users.php', 'user_form.php'];

$active_menu = '';
if (in_array($currentPage, $masters_pages)) $active_menu = 'masters';
if (in_array($currentPage, $fee_management_pages)) $active_menu = 'fee_management';
if (in_array($currentPage, $records_pages)) $active_menu = 'records';
if (in_array($currentPage, $communication_pages)) $active_menu = 'communication';
if (in_array($currentPage, $system_pages)) $active_menu = 'system';

try {
    $stmt = $pdo->query("SELECT setting_value FROM settings WHERE setting_key = 'school_name'");
    $school_name = $stmt->fetchColumn();
} catch (PDOException $e) {
    $school_name = 'School Fees';
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Fee Management</title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="public/css/style.css">
    
    <style>
        :root {
            --primary-color: #3b82f6; --primary-hover: #2563eb; --bg-color: #f1f5f9;
            --text-color: #334155; --text-light: #64748b; --card-bg: #ffffff; --border-color: #e2e8f0;
            --sidebar-bg: #1e293b; --sidebar-text: #cbd5e1; --sidebar-active-bg: #3b82f6; --header-bg: #ffffff;
        }
        [data-theme="dark"] {
            --primary-color: #60a5fa; --primary-hover: #3b82f6; --bg-color: #0f172a;
            --text-color: #e2e8f0; --text-light: #94a3b8; --card-bg: #1e293b; --border-color: #334155;
            --sidebar-bg: #0f172a; --sidebar-text: #cbd5e1; --sidebar-active-bg: #3b82f6; --header-bg: #1e293b;
        }
        body {
            font-family: 'Inter', sans-serif; background-color: var(--bg-color); color: var(--text-color);
            transition: background-color 0.2s, color 0.2s;
        }
        .card { background-color: var(--card-bg); border: 1px solid var(--border-color); border-radius: 0.75rem; box-shadow: 0 1px 3px rgba(0,0,0,0.05); }
        .sidebar { background-color: var(--sidebar-bg); color: var(--sidebar-text); z-index: 101; /* Layer fix */ }
        .sidebar-header h3 { font-weight: 600; }
        .sidebar-nav li a { transition: background-color 0.2s, padding-left 0.2s; border-radius: 6px; margin: 2px 10px; display: flex; align-items: center; }
        .sidebar-nav li a:hover { background-color: rgba(255,255,255,0.1); }
        .sidebar-nav li a.active, .sidebar-nav .submenu li a.active-sub { background-color: var(--sidebar-active-bg); color: #fff; font-weight: 500; }
        .sidebar-nav .submenu { background-color: transparent; list-style: none; padding-left: 20px; display: none; }
        .sidebar-nav li.active .submenu { display: block; }
        .sidebar-nav .has-submenu > a::after { content: '›'; font-size: 1.5rem; transform: rotate(90deg); transition: transform 0.2s; margin-left: auto; }
        .sidebar-nav .has-submenu.active > a::after { transform: rotate(-90deg); }
        .sidebar-nav .submenu li a:hover { background-color: rgba(255,255,255,0.05); }
        .btn { border-radius: 6px; font-weight: 500; transition: all 0.2s; padding: 10px 18px; }
        .btn-primary { background-color: var(--primary-color); color: #fff; border: none; }
        .btn-primary:hover { background-color: var(--primary-hover); transform: translateY(-1px); }
        .form-group input, .form-group select, .form-group textarea { background-color: var(--bg-color); border: 1px solid var(--border-color); border-radius: 6px; color: var(--text-color); padding: 12px; }
        .form-group input:focus, .form-group select:focus, .form-group textarea:focus { outline: none; border-color: var(--primary-color); box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.3); }
        .data-table { border-collapse: separate; border-spacing: 0; }
        .data-table th, .data-table td { border-bottom: 1px solid var(--border-color); }
        .data-table th { font-weight: 600; color: var(--text-light); }
        .data-table td { color: var(--text-color); }
        .data-table tbody tr:hover { background-color: rgba(0,0,0,0.02); }
        [data-theme="dark"] .data-table tbody tr:hover { background-color: rgba(255,255,255,0.03); }
        .header-toggles { display: flex; gap: 15px; }
        .toggle-btn { background: none; border: 1px solid var(--border-color); border-radius: 5px; cursor: pointer; padding: 5px 10px; color: var(--text-color); display: flex; align-items: center; justify-content: center; }
        .menu-toggle { display: none; font-size: 1.5rem; }
        .table-responsive { overflow-x: auto; }
        
        /* --- Top Navbar Layout Styles --- */
        [data-layout="top-nav"] .app-wrapper { flex-direction: column; }
        [data-layout="top-nav"] .sidebar { width: 100%; height: auto; flex-direction: row; align-items: center; padding: 0 20px; }
        [data-layout="top-nav"] .sidebar-header { padding: 15px 0; border: none; }
        [data-layout="top-nav"] .sidebar-nav { display: flex; flex-direction: row; padding: 0; margin-left: 20px; height: 100%; }
        [data-layout="top-nav"] .sidebar-nav > li { position: relative; }
        [data-layout="top-nav"] .sidebar-nav > li > a { padding: 20px 15px; }
        [data-layout="top-nav"] .sidebar-nav .submenu { position: absolute; top: 100%; left: 0; background-color: var(--sidebar-bg); border: 1px solid var(--border-color); border-radius: 0 0 5px 5px; min-width: 200px; z-index: 101; padding-left: 0; }
        /* [data-layout="top-nav"] .sidebar-nav .has-submenu:hover .submenu { display: block; }  <-- Removed for JS control */
        [data-layout="top-nav"] .sidebar-nav .has-submenu > a::after { display: none; }
        
        @media (max-width: 992px) {
            .sidebar { position: fixed; left: -280px; top: 0; height: 100%; z-index: 1000; transition: left 0.3s ease; }
            body.sidebar-visible .sidebar { left: 0; }
            .main-content { width: 100%; }
            .menu-toggle { display: block; }
            .header-title { display: none; }
        }
        .sidebar-nav .menu-icon { width: 18px; height: 18px; margin-right: 12px; stroke-width: 2; }
        .toggle-btn .feather { width: 18px; height: 18px; }

        /* --- Sticky Header & Scrollable Content --- */
        .main-content { height: 100vh; overflow-y: auto; }
        .header { position: sticky; top: 0; z-index: 100; }
    </style>
</head>
<body data-layout="sidebar" data-theme="light">
    <div class="app-wrapper">
        <aside class="sidebar">
            <div class="sidebar-header"><h3><?php echo htmlspecialchars($school_name); ?></h3></div>
            <ul class="sidebar-nav">
                <li><a href="dashboard.php" class="<?php echo ($currentPage == 'dashboard.php') ? 'active' : ''; ?>"><i class="menu-icon" data-feather="home"></i> Dashboard</a></li>
                <li><a href="students.php" class="<?php echo ($currentPage == 'students.php' || $currentPage == 'add_student.php' || $currentPage == 'edit_student.php') ? 'active' : ''; ?>"><i class="menu-icon" data-feather="users"></i> Student Management</a></li>
                
                <li class="has-submenu <?php echo ($active_menu == 'masters') ? 'active' : ''; ?>">
                    <a href="#"><i class="menu-icon" data-feather="tool"></i> Masters</a>
                    <ul class="submenu">
                        <li><a href="classes.php" class="<?php echo ($currentPage == 'classes.php') ? 'active-sub' : ''; ?>"><i class="menu-icon" data-feather="grid"></i> Classes</a></li>
                        <li><a href="fee_heads.php" class="<?php echo ($currentPage == 'fee_heads.php' || $currentPage == 'fee_head_form.php') ? 'active-sub' : ''; ?>"><i class="menu-icon" data-feather="tag"></i> Fee Heads</a></li>
                        <li><a href="fines.php" class="<?php echo ($currentPage == 'fines.php' || $currentPage == 'fine_form.php') ? 'active-sub' : ''; ?>"><i class="menu-icon" data-feather="alert-octagon"></i> Fine Rules</a></li>
                        <li><a href="stoppages.php" class="<?php echo ($currentPage == 'stoppages.php' || $currentPage == 'stoppage_form.php') ? 'active-sub' : ''; ?>"><i class="menu-icon" data-feather="truck"></i> Stoppages</a></li>
                    </ul>
                </li>
                
                <li class="has-submenu <?php echo ($active_menu == 'fee_management') ? 'active' : ''; ?>">
                    <a href="#"><i class="menu-icon" data-feather="dollar-sign"></i> Fee Management</a>
                    <ul class="submenu">
                        <li><a href="fee_structures.php" class="<?php echo ($currentPage == 'fee_structures.php') ? 'active-sub' : ''; ?>"><i class="menu-icon" data-feather="layers"></i> Fee Structures</a></li>
                        <li><a href="fee_assignment.php" class="<?php echo ($currentPage == 'fee_assignment.php') ? 'active-sub' : ''; ?>"><i class="menu-icon" data-feather="file-plus"></i> Fee Assignment</a></li>
                        <li><a href="bulk_fee_assignment.php" class="<?php echo ($currentPage == 'bulk_fee_assignment.php') ? 'active-sub' : ''; ?>"><i class="menu-icon" data-feather="calendar"></i> Bulk Assignment</a></li>
                        <li><a href="transport_fee_assignment.php" class="<?php echo ($currentPage == 'transport_fee_assignment.php') ? 'active-sub' : ''; ?>"><i class="menu-icon" data-feather="navigation"></i> Transport Assignment</a></li>
                        <li><a href="fee_collection.php" class="<?php echo ($currentPage == 'fee_collection.php') ? 'active-sub' : ''; ?>"><i class="menu-icon" data-feather="credit-card"></i> Fee Collection</a></li>
                    </ul>
                </li>

                <li class="has-submenu <?php echo ($active_menu == 'records') ? 'active' : ''; ?>">
                    <a href="#"><i class="menu-icon" data-feather="folder"></i> Records</a>
                    <ul class="submenu">
                        <li><a href="receipts.php" class="<?php echo ($currentPage == 'receipts.php') ? 'active-sub' : ''; ?>"><i class="menu-icon" data-feather="file-text"></i> Receipts</a></li>
                        <li><a href="reports.php" class="<?php echo ($currentPage == 'reports.php') ? 'active-sub' : ''; ?>"><i class="menu-icon" data-feather="bar-chart-2"></i> Reports</a></li>
                    </ul>
                </li>

                <li class="has-submenu <?php echo ($active_menu == 'communication') ? 'active' : ''; ?>">
                     <a href="#"><i class="menu-icon" data-feather="message-circle"></i> Communication</a>
                     <ul class="submenu">
                        <li><a href="whatsapp_center.php" class="<?php echo ($currentPage == 'whatsapp_center.php') ? 'active-sub' : ''; ?>"><i class="menu-icon" data-feather="message-square"></i> WhatsApp Center</a></li>
                    </ul>
                </li>

                <li class="has-submenu <?php echo ($active_menu == 'system') ? 'active' : ''; ?>">
                     <a href="#"><i class="menu-icon" data-feather="settings"></i> System</a>
                     <ul class="submenu">
                        <li><a href="users.php" class="<?php echo ($currentPage == 'users.php' || $currentPage == 'user_form.php') ? 'active-sub' : ''; ?>"><i class="menu-icon" data-feather="user"></i> User Management</a></li>
                        <li><a href="settings.php" class="<?php echo ($currentPage == 'settings.php') ? 'active-sub' : ''; ?>"><i class="menu-icon" data-feather="sliders"></i> Settings</a></li>
                    </ul>
                </li>
            </ul>
        </aside>

        <div class="main-content">
            <header class="header">
                 <button class="toggle-btn menu-toggle"><i data-feather="menu"></i></button>
                <div class="header-title">Welcome, <?php echo htmlspecialchars($_SESSION['username']); ?>!</div>
                 <div class="header-toggles" style="margin-left: auto; margin-right: 20px;">
                    <button id="theme-toggle" class="toggle-btn" title="Toggle Theme"></button>
                    <button id="layout-toggle" class="toggle-btn" title="Toggle Layout"></button>
                </div>
                <div class="user-info">
                    <strong>Role:</strong> <?php echo htmlspecialchars($_SESSION['role']); ?> | 
                    <a href="logout.php">Logout</a>
                </div>
            </header>
            
            <main class="page-content">

<script src="https://unpkg.com/feather-icons"></script>
<script>
document.addEventListener('DOMContentLoaded', () => {
    feather.replace();

    // --- UNIFIED Sub-menu Toggling for BOTH layouts ---
    const allSubmenuParents = document.querySelectorAll('.sidebar-nav .has-submenu');
    const allSubmenuLinks = document.querySelectorAll('.sidebar-nav .submenu a');

    allSubmenuParents.forEach(parentLi => {
        parentLi.querySelector('a').addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            
            const wasActive = parentLi.classList.contains('active');

            // Close all other menus
            allSubmenuParents.forEach(p => {
                if (p !== parentLi) { p.classList.remove('active'); }
            });

            // Toggle the current menu
            parentLi.classList.toggle('active');
        });
    });

    // Close all menus when clicking anywhere else on the page
    document.addEventListener('click', function(e) {
        if (!e.target.closest('.sidebar-nav')) {
            allSubmenuParents.forEach(p => p.classList.remove('active'));
        }
    });

    // Close menu after a sub-item is clicked
    allSubmenuLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            // We don't prevent default, just close the menus. The link will navigate.
            allSubmenuParents.forEach(p => p.classList.remove('active'));
        });
    });

    // --- Mobile Sidebar Toggle ---
    document.querySelector('.menu-toggle').addEventListener('click', () => {
        document.body.classList.toggle('sidebar-visible');
    });

    // --- Theme & Layout Toggling ---
    const themeToggle = document.getElementById('theme-toggle');
    const layoutToggle = document.getElementById('layout-toggle');
    const body = document.body;
    
    // Theme
    const savedTheme = localStorage.getItem('theme') || 'light';
    body.dataset.theme = savedTheme;
    themeToggle.innerHTML = savedTheme === 'dark' ? '<i data-feather="sun"></i>' : '<i data-feather="moon"></i>';
    themeToggle.addEventListener('click', () => {
        let newTheme = body.dataset.theme === 'light' ? 'dark' : 'light';
        body.dataset.theme = newTheme;
        themeToggle.innerHTML = newTheme === 'dark' ? '<i data-feather="sun"></i>' : '<i data-feather="moon"></i>';
        localStorage.setItem('theme', newTheme);
        feather.replace();
    });
    
    // Layout
    const savedLayout = localStorage.getItem('layout') || 'sidebar';
    body.dataset.layout = savedLayout;
    layoutToggle.innerHTML = savedLayout === 'top-nav' ? '<i data-feather="sidebar"></i>' : '<i data-feather="layout"></i>';
    layoutToggle.addEventListener('click', () => {
        let newLayout = body.dataset.layout === 'sidebar' ? 'top-nav' : 'sidebar';
        body.dataset.layout = newLayout;
        layoutToggle.innerHTML = newLayout === 'top-nav' ? '<i data-feather="sidebar"></i>' : '<i data-feather="layout"></i>';
        localStorage.setItem('layout', newLayout);
        feather.replace();
    });
});
</script>

