<?php
header('Content-Type: application/json');
require_once 'config/database.php';

if (!isset($_GET['class_id'])) {
    echo json_encode(['error' => 'Class ID not provided.']);
    exit();
}

$class_id = $_GET['class_id'];
$response = [
    'students' => [],
    'structure' => []
];

try {
    // Fetch students
    $stmt = $pdo->prepare("SELECT student_id, student_uid, full_name FROM students WHERE class_id = ? AND is_active = 1 ORDER BY full_name");
    $stmt->execute([$class_id]);
    $response['students'] = $stmt->fetchAll();

    // Fetch fee structure
    $stmt = $pdo->prepare("
        SELECT fs.structure_id, fh.head_name, fs.amount 
        FROM fee_structures fs
        JOIN fee_heads fh ON fs.fee_head_id = fh.fee_head_id
        WHERE fs.class_id = ?
    ");
    $stmt->execute([$class_id]);
    $response['structure'] = $stmt->fetchAll();

    echo json_encode($response);

} catch (PDOException $e) {
    echo json_encode(['error' => 'Database query failed.']);
}
?>