<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// Fetch all fine rules with the associated fee head name
try {
    $sql = "SELECT f.*, fh.head_name 
            FROM fines f
            JOIN fee_heads fh ON f.fee_head_id = fh.fee_head_id
            ORDER BY f.fine_name ASC";
    $fines = $pdo->query($sql)->fetchAll();
} catch (PDOException $e) {
    die("Error: Could not fetch fine rules. " . $e->getMessage());
}
?>

<div class="content-header">
    <h1>Fine Rules Management</h1>
    <a href="fine_form.php" class="btn btn-primary">Create New Fine Rule</a>
</div>

<!-- Message Display Area -->
<?php if(isset($_GET['success'])): ?><div class="alert alert-success"><?php echo htmlspecialchars($_GET['success']); ?></div><?php endif; ?>
<?php if(isset($_GET['error'])): ?><div class="alert alert-danger"><?php echo htmlspecialchars($_GET['error']); ?></div><?php endif; ?>

<div class="card">
    <div class="card-body">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Rule Name</th>
                    <th>Applies To (Fee Head)</th>
                    <th>Type</th>
                    <th>Value</th>
                    <th>Frequency</th>
                    <th>Starts After (Days)</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($fines) > 0): ?>
                    <?php foreach ($fines as $fine): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($fine['fine_name']); ?></td>
                            <td><?php echo htmlspecialchars($fine['head_name']); ?></td>
                            <td><?php echo htmlspecialchars($fine['fine_type']); ?></td>
                            <td><?php echo ($fine['fine_type'] == 'Percentage') ? $fine['fine_value'] . '%' : '₹ ' . number_format($fine['fine_value'], 2); ?></td>
                            <td><?php echo htmlspecialchars($fine['recurring_period'] == 'Daily' ? 'Recurring (Daily)' : 'One Time'); ?></td>
                            <td><?php echo htmlspecialchars($fine['start_after_days']); ?></td>
                            <td>
                                <a href="fine_form.php?id=<?php echo $fine['fine_id']; ?>" class="btn-action btn-edit">Edit</a>
                                <!-- You can add a delete form here if needed -->
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="7" style="text-align:center;">No fine rules found. Please create one.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>

