<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// Fetch all classes
try {
    $stmt = $pdo->query("SELECT class_id, class_name, section FROM classes ORDER BY class_name, section");
    $classes = $stmt->fetchAll();
} catch (PDOException $e) {
    die("Error: Could not fetch classes. " . $e->getMessage());
}
?>

<div class="content-header">
    <h1>Fee Structures</h1>
    <p style="margin:0;">Select a class to view or manage its fee structure.</p>
</div>

<div class="card">
    <div class="card-body">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Class Name</th>
                    <th>Section</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($classes) > 0): ?>
                    <?php foreach ($classes as $class): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($class['class_name']); ?></td>
                            <td><?php echo htmlspecialchars($class['section']); ?></td>
                            <td>
                                <a href="manage_structure.php?class_id=<?php echo $class['class_id']; ?>" class="btn btn-primary">Manage Structure</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="3" style="text-align:center;">No classes found. Please create a class first.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>