<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// Default values for "Add" mode
$head = ['fee_head_id' => '', 'head_name' => '', 'description' => ''];
$form_action = 'add';
$page_title = 'Create New Fee Head';
$button_text = '💾 Create Fee Head';

// Check for "Edit" mode
if (isset($_GET['id']) && !empty($_GET['id'])) {
    $fee_head_id = $_GET['id'];
    $form_action = 'edit';
    $page_title = 'Edit Fee Head';
    $button_text = '🔄 Update Fee Head';

    try {
        $stmt = $pdo->prepare("SELECT * FROM fee_heads WHERE fee_head_id = :id");
        $stmt->execute(['id' => $fee_head_id]);
        $head = $stmt->fetch();
        if (!$head) {
            header("Location: fee_heads.php?error=Fee head not found.");
            exit();
        }
    } catch (PDOException $e) {
        die("Error: " . $e->getMessage());
    }
}
?>

<div class="content-header">
    <h1><?php echo $page_title; ?></h1>
    <a href="fee_heads.php" class="btn">⬅️ Back to Fee Head List</a>
</div>

<div class="card">
    <div class="card-body">
        <form action="process_fee_head.php" method="POST">
            <input type="hidden" name="action" value="<?php echo $form_action; ?>">
            <input type="hidden" name="fee_head_id" value="<?php echo $head['fee_head_id']; ?>">

            <div class="form-group" style="padding: 0 10px;">
                <label for="head_name">Fee Head Name</label>
                <input type="text" id="head_name" name="head_name" value="<?php echo htmlspecialchars($head['head_name']); ?>" required>
            </div>

            <div class="form-group" style="padding: 0 10px;">
                <label for="description">Description</label>
                <textarea id="description" name="description" rows="3"><?php echo htmlspecialchars($head['description']); ?></textarea>
            </div>

            <div class="form-footer">
                <button type="submit" class="btn btn-primary"><?php echo $button_text; ?></button>
            </div>
        </form>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>