<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// Fetch all classes from the database
try {
    $stmt = $pdo->query("SELECT * FROM classes ORDER BY class_name, section");
    $classes = $stmt->fetchAll();
} catch (PDOException $e) {
    die("Error: Could not fetch classes. " . $e->getMessage());
}
?>

<div class="content-header">
    <h1>Class Management</h1>
    <a href="class_form.php" class="btn btn-primary">Create New Class</a>
</div>

<?php if(isset($_GET['success'])): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($_GET['success']); ?></div>
<?php endif; ?>
<?php if(isset($_GET['error'])): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($_GET['error']); ?></div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Class Name</th>
                    <th>Section</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($classes) > 0): ?>
                    <?php foreach ($classes as $class): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($class['class_name']); ?></td>
                            <td><?php echo htmlspecialchars($class['section']); ?></td>
                            <td>
                                <a href="class_form.php?id=<?php echo $class['class_id']; ?>" class="btn-action btn-edit">Edit</a>
                                <form action="process_class.php" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure? Deleting a class will affect assigned students.');">
                                    <input type="hidden" name="action" value="delete">
                                    <input type="hidden" name="class_id" value="<?php echo $class['class_id']; ?>">
                                    <button type="submit" class="btn-action btn-delete">Delete</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="3" style="text-align:center;">No classes found. Please create one.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>