<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// --- Default values for "Add" mode ---
$class = ['class_id' => '', 'class_name' => '', 'section' => ''];
$form_action = 'add';
$page_title = 'Create New Class';
$button_text = '💾 Create Class';

// --- Check if an ID is provided for "Edit" mode ---
if (isset($_GET['id']) && !empty($_GET['id'])) {
    $class_id = $_GET['id'];
    $form_action = 'edit';
    $page_title = 'Edit Class';
    $button_text = '🔄 Update Class';

    try {
        $stmt = $pdo->prepare("SELECT * FROM classes WHERE class_id = :class_id");
        $stmt->execute(['class_id' => $class_id]);
        $class = $stmt->fetch();
        if (!$class) {
            header("Location: classes.php?error=Class not found.");
            exit();
        }
    } catch (PDOException $e) {
        die("Error: " . $e->getMessage());
    }
}
?>

<div class="content-header">
    <h1><?php echo $page_title; ?></h1>
    <a href="classes.php" class="btn">⬅️ Back to Class List</a>
</div>

<div class="card">
    <div class="card-body">
        <form action="process_class.php" method="POST">
            <input type="hidden" name="action" value="<?php echo $form_action; ?>">
            <input type="hidden" name="class_id" value="<?php echo $class['class_id']; ?>">

            <div class="form-row">
                <div class="form-group">
                    <label for="class_name">Class Name</label>
                    <input type="text" id="class_name" name="class_name" value="<?php echo htmlspecialchars($class['class_name']); ?>" required>
                </div>
                <div class="form-group">
                    <label for="section">Section</label>
                    <input type="text" id="section" name="section" value="<?php echo htmlspecialchars($class['section']); ?>" required>
                </div>
            </div>

            <div class="form-footer">
                <button type="submit" class="btn btn-primary"><?php echo $button_text; ?></button>
            </div>
        </form>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>