<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// Fetch classes and stoppages for dropdowns
$classes = $pdo->query("SELECT class_id, class_name, section FROM classes ORDER BY class_name ASC, section ASC")->fetchAll();
$stoppages = $pdo->query("SELECT stoppage_id, stoppage_name FROM stoppages ORDER BY stoppage_name ASC")->fetchAll();
?>

<div class="content-header">
    <h1>Add New Student</h1>
    <a href="students.php" class="btn">⬅️ Back to Student List</a>
</div>

<div class="card">
    <div class="card-body">
        <form action="process_student.php" method="POST">
            <input type="hidden" name="action" value="add">

            <div class="form-row">
                <div class="form-group">
                    <label for="student_uid">Student UID</label>
                    <input type="text" id="student_uid" name="student_uid" required placeholder="e.g., S2025001">
                </div>
                <div class="form-group">
                    <label for="full_name">Full Name</label>
                    <input type="text" id="full_name" name="full_name" required>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="parent_name">Parent's Name</label>
                    <input type="text" id="parent_name" name="parent_name" required>
                </div>
                 <div class="form-group">
                    <label for="guardian_contact">Guardian's Contact</label>
                    <input type="text" id="guardian_contact" name="guardian_contact" required>
                </div>
            </div>
            
            <div class="form-row">
                 <div class="form-group">
                    <label for="class_id">Class</label>
                    <select id="class_id" name="class_id" required>
                        <option value="">-- Select a Class --</option>
                        <?php foreach ($classes as $class): ?>
                            <option value="<?php echo $class['class_id']; ?>"><?php echo htmlspecialchars($class['class_name'] . ' - ' . $class['section']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="roll_no">Roll Number</label>
                    <input type="text" id="roll_no" name="roll_no">
                </div>
            </div>

            <div class="form-group" style="padding: 0 10px;">
                <label for="stoppage_id">Transport Stoppage (Optional)</label>
                <select id="stoppage_id" name="stoppage_id">
                    <option value="">-- No Transport --</option>
                    <?php foreach ($stoppages as $stoppage): ?>
                        <option value="<?php echo $stoppage['stoppage_id']; ?>"><?php echo htmlspecialchars($stoppage['stoppage_name']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-footer">
                <button type="submit" class="btn btn-primary">💾 Save Student</button>
            </div>
        </form>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>

