<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// Default values for "Add" mode
$stoppage = ['stoppage_id' => '', 'stoppage_name' => '', 'monthly_fee' => ''];
$form_action = 'add';
$page_title = 'Create New Stoppage';

// Check for "Edit" mode
if (isset($_GET['id'])) {
    $stmt = $pdo->prepare("SELECT * FROM stoppages WHERE stoppage_id = ?");
    $stmt->execute([$_GET['id']]);
    $stoppage = $stmt->fetch();
    $form_action = 'edit';
    $page_title = 'Edit Stoppage';
}
?>

<div class="content-header">
    <h1><?php echo $page_title; ?></h1>
    <a href="stoppages.php" class="btn">⬅️ Back to Stoppage List</a>
</div>

<div class="card">
    <div class="card-body">
        <form action="process_stoppage.php" method="POST">
            <input type="hidden" name="action" value="<?php echo $form_action; ?>">
            <input type="hidden" name="stoppage_id" value="<?php echo $stoppage['stoppage_id']; ?>">

            <div class="form-row">
                <div class="form-group">
                    <label for="stoppage_name">Stoppage Name</label>
                    <input type="text" name="stoppage_name" value="<?php echo htmlspecialchars($stoppage['stoppage_name']); ?>" required>
                </div>
                <div class="form-group">
                    <label for="monthly_fee">Monthly Fee (₹)</label>
                    <input type="number" step="0.01" name="monthly_fee" value="<?php echo htmlspecialchars($stoppage['monthly_fee']); ?>" required>
                </div>
            </div>
            <div class="form-footer">
                <button type="submit" class="btn btn-primary">Save Stoppage</button>
            </div>
        </form>
    </div>
</div>
    
<?php require_once 'includes/footer.php'; ?>
