<?php
require_once 'config/database.php';

// Security Check: Ensure this script is accessed via a POST request and an action is set.
if ($_SERVER["REQUEST_METHOD"] !== "POST" || !isset($_POST['action'])) {
    header("Location: students.php");
    exit();
}

$action = $_POST['action'];

try {
    // ======================================================
    // === HANDLE ADDING A NEW STUDENT ======================
    // ======================================================
    if ($action == 'add') {
        if (empty($_POST['student_uid']) || empty($_POST['full_name']) || empty($_POST['class_id'])) {
            throw new Exception("Missing required fields.");
        }
        
        $sql = "INSERT INTO students (student_uid, full_name, parent_name, guardian_contact, class_id, roll_no, stoppage_id) 
                VALUES (:student_uid, :full_name, :parent_name, :guardian_contact, :class_id, :roll_no, :stoppage_id)";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':student_uid' => trim($_POST['student_uid']),
            ':full_name' => trim($_POST['full_name']),
            ':parent_name' => trim($_POST['parent_name']),
            ':guardian_contact' => trim($_POST['guardian_contact']),
            ':class_id' => $_POST['class_id'],
            ':roll_no' => trim($_POST['roll_no']),
            ':stoppage_id' => (!empty($_POST['stoppage_id'])) ? $_POST['stoppage_id'] : null
        ]);
        header("Location: students.php?success=Student added successfully!");
    }

    // ======================================================
    // === HANDLE EDITING AN EXISTING STUDENT ===============
    // ======================================================
    elseif ($action == 'edit') {
        if (empty($_POST['student_id']) || empty($_POST['student_uid'])) {
            throw new Exception("Missing required fields for update.");
        }
        
        $sql = "UPDATE students SET 
                    student_uid = :student_uid, 
                    full_name = :full_name, 
                    parent_name = :parent_name, 
                    guardian_contact = :guardian_contact, 
                    class_id = :class_id, 
                    roll_no = :roll_no, 
                    stoppage_id = :stoppage_id 
                WHERE student_id = :student_id";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':student_uid' => trim($_POST['student_uid']),
            ':full_name' => trim($_POST['full_name']),
            ':parent_name' => trim($_POST['parent_name']),
            ':guardian_contact' => trim($_POST['guardian_contact']),
            ':class_id' => $_POST['class_id'],
            ':roll_no' => trim($_POST['roll_no']),
            ':stoppage_id' => (!empty($_POST['stoppage_id'])) ? $_POST['stoppage_id'] : null,
            ':student_id' => $_POST['student_id']
        ]);
        header("Location: students.php?success=Student details updated successfully!");
    }

    // ======================================================
    // === HANDLE DELETING & ARCHIVING A STUDENT ============
    // ======================================================
    elseif ($action == 'delete') {
        if (empty($_POST['student_id'])) {
            throw new Exception("Invalid student selected for deletion.");
        }
        $student_id = $_POST['student_id'];

        $pdo->beginTransaction();

        // Archive Payments and Receipts, then delete them from active tables
        $pdo->prepare("INSERT INTO deleted_student_payments SELECT *, NOW() FROM payments WHERE student_id = ?")->execute([$student_id]);
        $pdo->prepare("DELETE FROM payments WHERE student_id = ?")->execute([$student_id]);
        $pdo->prepare("INSERT INTO deleted_student_receipts SELECT *, NOW() FROM receipts WHERE student_id = ?")->execute([$student_id]);
        $pdo->prepare("DELETE FROM receipts WHERE student_id = ?")->execute([$student_id]);

        // Clean Up Unpaid Fees
        $pdo->prepare("DELETE FROM fee_assignments WHERE student_id = ? AND status = 'Pending'")->execute([$student_id]);

        // Soft-Delete the Student
        $pdo->prepare("UPDATE students SET is_active = 0 WHERE student_id = ?")->execute([$student_id]);

        $pdo->commit();
        header("Location: students.php?success=Student has been deactivated and records have been archived.");
    }

} catch (Exception $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    if ($e->getCode() == '23000') {
        $error_message = "A student with this UID already exists.";
    } else {
        $error_message = "Operation failed: " . $e->getMessage();
    }
    header("Location: students.php?error=" . urlencode($error_message));
}
exit();
?>

