<?php
require_once 'config/database.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['action'])) {
    header('Location: stoppages.php');
    exit();
}
    
$action = $_POST['action'];
$data = ['name' => $_POST['stoppage_name'], 'fee' => $_POST['monthly_fee'], 'id' => $_POST['stoppage_id']];

try {
    if ($action == 'add') {
        $sql = "INSERT INTO stoppages (stoppage_name, monthly_fee) VALUES (:name, :fee)";
        unset($data['id']);
    } else {
        $sql = "UPDATE stoppages SET stoppage_name = :name, monthly_fee = :fee WHERE stoppage_id = :id";
    }
    $pdo->prepare($sql)->execute($data);
    header("Location: stoppages.php?success=Stoppage saved successfully!");
} catch (PDOException $e) {
    header("Location: stoppages.php?error=" . urlencode($e->getMessage()));
}
?>
