<?php
require_once 'config/database.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: settings.php');
    exit();
}

try {
    // --- 1. Update Text-Based Settings ---
    $text_settings = ['school_name', 'school_address', 'school_contact', 'academic_session'];
    $stmt = $pdo->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = ?");

    foreach ($text_settings as $key) {
        if (isset($_POST[$key])) {
            $stmt->execute([$_POST[$key], $key]);
        }
    }

    // --- 2. Handle File Upload for School Logo ---
    if (isset($_FILES['school_logo']) && $_FILES['school_logo']['error'] == UPLOAD_ERR_OK) {
        $file = $_FILES['school_logo'];
        $upload_dir = 'public/images/';
        
        // Basic validation
        $allowed_types = ['image/jpeg', 'image/png', 'image/gif'];
        if (!in_array($file['type'], $allowed_types)) {
            throw new Exception("Invalid file type for logo. Only JPG, PNG, GIF are allowed.");
        }
        
        // Generate a unique filename
        $filename = 'logo_' . time() . '.' . pathinfo($file['name'], PATHINFO_EXTENSION);
        $destination = $upload_dir . $filename;
        
        // Move the file
        if (move_uploaded_file($file['tmp_name'], $destination)) {
            // Update the database with the new filename
            $stmt = $pdo->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = 'school_logo'");
            $stmt->execute([$filename]);
        } else {
            throw new Exception("Could not move uploaded file.");
        }
    }

    header("Location: settings.php?success=Settings updated successfully!");
    
} catch (Exception $e) {
    header("Location: settings.php?error=" . urlencode($e->getMessage()));
}
exit();