<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// Fetch all fee heads from the database
try {
    $stmt = $pdo->query("SELECT * FROM fee_heads ORDER BY head_name ASC");
    $fee_heads = $stmt->fetchAll();
} catch (PDOException $e) {
    die("Error: Could not fetch fee heads. " . $e->getMessage());
}
?>

<div class="content-header">
    <h1>Fee Head Management</h1>
    <a href="fee_head_form.php" class="btn btn-primary">Create New Fee Head</a>
</div>

<?php if(isset($_GET['success'])): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($_GET['success']); ?></div>
<?php endif; ?>
<?php if(isset($_GET['error'])): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($_GET['error']); ?></div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Fee Head Name</th>
                    <th>Description</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($fee_heads) > 0): ?>
                    <?php foreach ($fee_heads as $head): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($head['head_name']); ?></td>
                            <td><?php echo htmlspecialchars($head['description']); ?></td>
                            <td>
                                <a href="fee_head_form.php?id=<?php echo $head['fee_head_id']; ?>" class="btn-action btn-edit">Edit</a>
                                <form action="process_fee_head.php" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure? This could affect existing fee structures.');">
                                    <input type="hidden" name="action" value="delete">
                                    <input type="hidden" name="fee_head_id" value="<?php echo $head['fee_head_id']; ?>">
                                    <button type="submit" class="btn-action btn-delete">Delete</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="3" style="text-align:center;">No fee heads found. Please create one.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>