<?php
require_once 'config/database.php';
require_once 'includes/header.php';
?>

<div class="content-header">
    <h1>Collect Student Fees</h1>
</div>

<!-- Message Display Area -->
<?php if(isset($_GET['success'])): ?><div class="alert alert-success"><?php echo htmlspecialchars($_GET['success']); ?></div><?php endif; ?>
<?php if(isset($_GET['error'])): ?><div class="alert alert-danger"><?php echo htmlspecialchars($_GET['error']); ?></div><?php endif; ?>

<div class="card">
    <div class="card-body">
        <h3>1. Find Student</h3>
        <div class="form-group" style="padding:0;">
            <label for="student_search">Search by Student UID, Name, or Contact</label>
            <input type="text" id="student_search" placeholder="Start typing to search..." autocomplete="off">
            <div id="search-results"></div>
        </div>
    </div>
</div>

<!-- This section will be populated dynamically -->
<div id="fee-details-container" style="display:none; margin-top: 20px;"></div>

<script>
// --- Live Search Functionality ---
const searchInput = document.getElementById('student_search');
const searchResults = document.getElementById('search-results');
const feeDetailsContainer = document.getElementById('fee-details-container');

searchInput.addEventListener('keyup', function() {
    const term = this.value;
    if (term.length < 2) {
        searchResults.innerHTML = '';
        searchResults.style.display = 'none';
        return;
    }
    
    fetch(`search_student.php?term=${term}`)
        .then(response => response.json())
        .then(data => {
            let resultsHtml = '<ul>';
            if (data.length > 0) {
                data.forEach(student => {
                    resultsHtml += `<li data-id="${student.student_id}">${student.full_name} (${student.student_uid})</li>`;
                });
            } else {
                resultsHtml += '<li>No students found</li>';
            }
            resultsHtml += '</ul>';
            searchResults.innerHTML = resultsHtml;
            searchResults.style.display = 'block';
        });
});

// --- Handle Clicks on Search Results ---
searchResults.addEventListener('click', function(e) {
    if (e.target && e.target.nodeName === "LI" && e.target.dataset.id) {
        const studentId = e.target.dataset.id;
        loadFeeDetails(studentId);
        this.innerHTML = '';
        this.style.display = 'none';
        searchInput.value = e.target.textContent;
    }
});

// --- Function to Load Fee Details ---
function loadFeeDetails(studentId) {
    fetch(`get_student_dues.php?id=${studentId}`)
        .then(response => response.json())
        .then(data => {
            if (data.error) {
                alert(data.error);
                return;
            }
            
            let totalDue = 0;
            let duesHtml = `
                <h3>2. Outstanding Fees for ${data.student.full_name}</h3>
                <form action="process_payment.php" method="POST">
                    <input type="hidden" name="student_id" value="${studentId}">
                    <table class="data-table">
                        <thead><tr><th><input type="checkbox" id="select-all-dues" checked></th><th>Fee Title</th><th>Amount Due</th><th>Paid</th><th>Balance</th></tr></thead>
                        <tbody>`;
            
            if (data.dues.length > 0) {
                data.dues.forEach(due => {
                    const balance = parseFloat(due.amount_due) - parseFloat(due.amount_paid);
                    totalDue += balance;
                    
                    // --- ENHANCEMENT: Add a special class for fine rows ---
                    const isFine = String(due.assignment_id).startsWith('fine_');
                    const rowClass = isFine ? 'class="fine-row"' : '';

                    duesHtml += `<tr ${rowClass}>
                        <td><input type="checkbox" class="due-checkbox" name="assignment_ids[]" value="${due.assignment_id}" data-amount="${balance.toFixed(2)}" checked></td>
                        <td>${due.assignment_title}</td>
                        <td>${parseFloat(due.amount_due).toFixed(2)}</td>
                        <td>${parseFloat(due.amount_paid).toFixed(2)}</td>
                        <td>${balance.toFixed(2)}</td>
                    </tr>`;
                });
            } else {
                duesHtml += '<tr><td colspan="5" style="text-align:center;">No outstanding dues found.</td></tr>';
            }
            duesHtml += `</tbody></table>`;
            
            // Payment Form Section
            duesHtml += `
                <div class="payment-summary">
                    <h3>3. Enter Payment Details</h3>
                    <h4>Total Selected Due: ₹ <span id="total-due-amount">${totalDue.toFixed(2)}</span></h4>
                    <div class="form-row">
                        <div class="form-group">
                            <label for="amount_paid">Amount Being Paid</label>
                            <input type="number" step="0.01" name="amount_paid" id="amount_paid" value="${totalDue.toFixed(2)}" required>
                        </div>
                        <div class="form-group">
                            <label for="payment_date">Payment Date</label>
                            <input type="date" name="payment_date" value="<?php echo date('Y-m-d'); ?>" required>
                        </div>
                    </div>
                    <div class="form-row">
                         <div class="form-group">
                            <label for="payment_mode">Payment Mode</label>
                            <select name="payment_mode" id="payment_mode">
                                <option>Cash</option>
                                <option>Bank</option>
                                <option>Cheque</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="ref_no">Ref / Cheque No.</label>
                            <input type="text" name="ref_no" id="ref_no">
                        </div>
                    </div>
                     <div class="form-footer">
                        <button type="submit" class="btn btn-primary">Process Payment</button>
                    </div>
                </div>
            </form>`;
            
            feeDetailsContainer.innerHTML = duesHtml;
            feeDetailsContainer.style.display = 'block';

            // Add event listeners for checkboxes
            updateTotal(); // Initial calculation
            document.getElementById('select-all-dues').addEventListener('change', toggleAllDues);
            document.querySelectorAll('.due-checkbox').forEach(cb => cb.addEventListener('change', updateTotal));
        });
}

function updateTotal() {
    let total = 0;
    document.querySelectorAll('.due-checkbox:checked').forEach(cb => {
        total += parseFloat(cb.dataset.amount);
    });
    document.getElementById('total-due-amount').textContent = total.toFixed(2);
    document.getElementById('amount_paid').value = total.toFixed(2);
}

function toggleAllDues() {
    const isChecked = document.getElementById('select-all-dues').checked;
    document.querySelectorAll('.due-checkbox').forEach(cb => cb.checked = isChecked);
    updateTotal();
}
</script>

<style>
/* Styles for the search results dropdown */
#search-results { display: none; border: 1px solid #ddd; border-top: none; max-height: 200px; overflow-y: auto; background: #fff; position: relative; z-index: 10; }
#search-results ul { list-style: none; margin: 0; padding: 0; }
#search-results li { padding: 10px; cursor: pointer; }
#search-results li:hover { background-color: #f0f0f0; }
.payment-summary { margin-top: 20px; padding: 15px; background: #f8f9fa; border-radius: 5px; }

/* --- ADDED: Style for highlighting fine rows --- */
.fine-row {
    background-color: #fff3cd !important; /* Light yellow warning color */
    color: #856404;
    font-style: italic;
}
.fine-row td {
    border-color: #ffeeba;
}
</style>

<?php
require_once 'includes/footer.php';
?>
