<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// Fetch all classes for the dropdown
try {
    $classes = $pdo->query("SELECT * FROM classes ORDER BY class_name, section")->fetchAll();
} catch (PDOException $e) {
    die("Could not fetch classes.");
}
?>
<div class="content-header">
    <h1>Assign Fees to Students</h1>
</div>

<?php if(isset($_GET['success'])): ?><div class="alert alert-success"><?php echo htmlspecialchars($_GET['success']); ?></div><?php endif; ?>
<?php if(isset($_GET['error'])): ?><div class="alert alert-danger"><?php echo htmlspecialchars($_GET['error']); ?></div><?php endif; ?>

<div class="card">
    <div class="card-body">
        <form id="assignment-form" action="process_fee_assignment.php" method="POST">
            <div class="form-row">
                <div class="form-group">
                    <label for="class_id">1. Select a Class</label>
                    <select id="class_id" name="class_id" required>
                        <option value="">-- Choose Class --</option>
                        <?php foreach($classes as $class): ?>
                            <option value="<?php echo $class['class_id']; ?>"><?php echo htmlspecialchars($class['class_name'] . ' - ' . $class['section']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            
            <div id="class-data-container" style="display:none;">
                <hr>
                <div id="fee-structure-display"></div>
                
                <div id="student-list-display" style="margin-top: 20px;"></div>

                <hr>
                <h3>3. Assignment Details</h3>
                <div class="form-row">
                    <div class="form-group">
                        <label for="assignment_title">Assignment Title</label>
                        <input type="text" id="assignment_title" name="assignment_title" placeholder="e.g., Monthly Fee - April 2025" required>
                    </div>
                    <div class="form-group">
                        <label for="due_date">Due Date</label>
                        <input type="date" id="due_date" name="due_date" required>
                    </div>
                </div>
                
                <div class="form-footer">
                    <button type="submit" class="btn btn-primary">Assign Fees to Selected Students</button>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
document.getElementById('class_id').addEventListener('change', function() {
    const classId = this.value;
    const container = document.getElementById('class-data-container');
    
    if (!classId) {
        container.style.display = 'none';
        return;
    }
    
    // Fetch data from the server
    fetch(`get_class_data.php?class_id=${classId}`)
        .then(response => response.json())
        .then(data => {
            if (data.error) {
                alert(data.error);
                container.style.display = 'none';
                return;
            }

            // --- Populate Fee Structure ---
            const structureDiv = document.getElementById('fee-structure-display');
            let totalAmount = 0;
            let structureHtml = '<h3>2. Fee Structure for this Class</h3><ul style="list-style:none; padding:0;">';
            if (data.structure.length > 0) {
                data.structure.forEach(item => {
                    structureHtml += `<li>${item.head_name}: <strong>₹ ${parseFloat(item.amount).toFixed(2)}</strong></li>`;
                    totalAmount += parseFloat(item.amount);
                });
                structureHtml += `<li style="margin-top:10px; border-top:1px solid #ddd; padding-top:10px;"><strong>Total: ₹ ${totalAmount.toFixed(2)}</strong></li>`;
            } else {
                structureHtml += '<li>No fee structure defined for this class.</li>';
            }
            structureHtml += '</ul>';
            structureDiv.innerHTML = structureHtml;
            
            // --- Populate Student List ---
            const studentDiv = document.getElementById('student-list-display');
            let studentHtml = '<h3><input type="checkbox" id="select-all-students" checked> Select Students</h3><table class="data-table"><thead><tr><th></th><th>UID</th><th>Name</th></tr></thead><tbody>';
            if (data.students.length > 0) {
                data.students.forEach(student => {
                    studentHtml += `<tr>
                                        <td><input type="checkbox" name="student_ids[]" value="${student.student_id}" checked></td>
                                        <td>${student.student_uid}</td>
                                        <td>${student.full_name}</td>
                                    </tr>`;
                });
            } else {
                studentHtml += '<tr><td colspan="3" style="text-align:center;">No active students in this class.</td></tr>';
            }
            studentHtml += '</tbody></table>';
            studentDiv.innerHTML = studentHtml;

            // Add functionality to the "select all" checkbox
            document.getElementById('select-all-students').addEventListener('change', function() {
                const checkboxes = document.querySelectorAll('input[name="student_ids[]"]');
                checkboxes.forEach(checkbox => checkbox.checked = this.checked);
            });

            container.style.display = 'block';
        })
        .catch(error => {
            console.error('Error fetching class data:', error);
            container.style.display = 'none';
        });
});
</script>

<?php
require_once 'includes/footer.php';
?>