<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// 1. Check if an ID is provided in the URL
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: students.php?error=Invalid student selected.");
    exit();
}
$student_id = $_GET['id'];

try {
    // 2. Fetch the specific student's data
    $stmt = $pdo->prepare("SELECT * FROM students WHERE student_id = :student_id");
    $stmt->bindParam(':student_id', $student_id, PDO::PARAM_INT);
    $stmt->execute();
    $student = $stmt->fetch();

    if (!$student) {
        header("Location: students.php?error=Student not found.");
        exit();
    }

    // 3. Fetch all classes and stoppages for the dropdowns
    $classes = $pdo->query("SELECT class_id, class_name, section FROM classes ORDER BY class_name, section")->fetchAll();
    $stoppages = $pdo->query("SELECT stoppage_id, stoppage_name FROM stoppages ORDER BY stoppage_name ASC")->fetchAll();

} catch (PDOException $e) {
    die("Error: " . $e->getMessage());
}
?>

<div class="content-header">
    <h1>Edit Student Details</h1>
    <a href="students.php" class="btn">⬅️ Back to Student List</a>
</div>

<div class="card">
    <div class="card-body">
        <form action="process_student.php" method="POST">
            <!-- Hidden inputs to pass the action and the student ID -->
            <input type="hidden" name="action" value="edit">
            <input type="hidden" name="student_id" value="<?php echo $student['student_id']; ?>">

            <div class="form-row">
                <div class="form-group">
                    <label for="student_uid">Student UID</label>
                    <input type="text" id="student_uid" name="student_uid" required value="<?php echo htmlspecialchars($student['student_uid']); ?>">
                </div>
                <div class="form-group">
                    <label for="full_name">Full Name</label>
                    <input type="text" id="full_name" name="full_name" required value="<?php echo htmlspecialchars($student['full_name']); ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="parent_name">Parent's Name</label>
                    <input type="text" id="parent_name" name="parent_name" required value="<?php echo htmlspecialchars($student['parent_name']); ?>">
                </div>
                 <div class="form-group">
                    <label for="guardian_contact">Guardian's Contact</label>
                    <input type="text" id="guardian_contact" name="guardian_contact" required value="<?php echo htmlspecialchars($student['guardian_contact']); ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="class_id">Class</label>
                    <select id="class_id" name="class_id" required>
                        <option value="">-- Select a Class --</option>
                        <?php foreach ($classes as $class): ?>
                            <option value="<?php echo $class['class_id']; ?>" <?php echo ($class['class_id'] == $student['class_id']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($class['class_name'] . ' - ' . $class['section']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="roll_no">Roll Number</label>
                    <input type="text" id="roll_no" name="roll_no" value="<?php echo htmlspecialchars($student['roll_no']); ?>">
                </div>
            </div>

            <div class="form-group" style="padding: 0 10px;">
                <label for="stoppage_id">Transport Stoppage (Optional)</label>
                <select id="stoppage_id" name="stoppage_id">
                    <option value="">-- No Transport --</option>
                    <?php foreach ($stoppages as $stoppage): ?>
                        <option value="<?php echo $stoppage['stoppage_id']; ?>" <?php echo ($stoppage['stoppage_id'] == $student['stoppage_id']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($stoppage['stoppage_name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-footer">
                <button type="submit" class="btn btn-primary">🔄 Update Student</button>
            </div>
        </form>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>
