<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// Determine the date to show the report for
// Default to today if no date is selected
$report_date = $_GET['report_date'] ?? date('Y-m-d');
$collections = [];
$total_collection = 0;

try {
    // Query to fetch all payments for the selected date
    // We JOIN with other tables to get student and staff names
    $sql = "
        SELECT 
            p.payment_id,
            p.payment_date,
            p.amount,
            p.payment_mode,
            s.student_uid,
            s.full_name AS student_name,
            u.full_name AS collected_by_name
        FROM payments p
        JOIN students s ON p.student_id = s.student_id
        JOIN users u ON p.collected_by = u.user_id
        WHERE p.payment_date = ?
        ORDER BY p.created_at DESC
    ";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$report_date]);
    $collections = $stmt->fetchAll();

    // Calculate the total collection for the day
    foreach($collections as $collection) {
        $total_collection += $collection['amount'];
    }

} catch(PDOException $e) {
    echo "<div class='alert alert-danger'>Database Error: " . $e->getMessage() . "</div>";
}
?>

<div class="content-header">
    <h1>Daily Collection Report</h1>
    <a href="reports.php" class="btn">⬅️ Back to Reports Menu</a>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="daily_collection_report.php" class="filter-form">
            <div class="form-group">
                <label for="report_date">Select Date:</label>
                <input type="date" id="report_date" name="report_date" value="<?php echo htmlspecialchars($report_date); ?>">
            </div>
            <button type="submit" class="btn btn-primary">View Report</button>
        </form>
    </div>
</div>

<div class="card" style="margin-top:20px;">
    <div class="card-body">
        <div class="report-header">
            <h3>Report for: <?php echo date("d F, Y", strtotime($report_date)); ?></h3>
            <div class="total-display">
                Total Collection: <span>₹ <?php echo number_format($total_collection, 2); ?></span>
            </div>
        </div>

        <table class="data-table">
            <thead>
                <tr>
                    <th>Receipt No.</th>
                    <th>Student UID</th>
                    <th>Student Name</th>
                    <th>Mode</th>
                    <th>Amount (₹)</th>
                    <th>Collected By</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($collections) > 0): ?>
                    <?php foreach ($collections as $row): ?>
                        <tr>
                            <td>
                                <a href="view_receipt.php?id=<?php echo $row['payment_id']; // Simple link using payment_id for now ?>" target="_blank">
                                    RCPT-<?php echo str_pad($row['payment_id'], 6, '0', STR_PAD_LEFT); ?>
                                </a>
                            </td>
                            <td><?php echo htmlspecialchars($row['student_uid']); ?></td>
                            <td><?php echo htmlspecialchars($row['student_name']); ?></td>
                            <td><?php echo htmlspecialchars($row['payment_mode']); ?></td>
                            <td style="text-align:right;"><?php echo number_format($row['amount'], 2); ?></td>
                            <td><?php echo htmlspecialchars($row['collected_by_name']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" style="text-align:center;">No collections found for this date.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<style>
.filter-form { display: flex; align-items: flex-end; gap: 15px; }
.report-header { display:flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
.total-display { font-size: 1.5rem; font-weight: bold; }
.total-display span { color: #28a745; }
</style>

<?php
require_once 'includes/footer.php';
?>