<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// Fetch necessary data for the form
try {
    $classes = $pdo->query("SELECT * FROM classes ORDER BY class_name, section")->fetchAll();
    $settings = $pdo->query("SELECT setting_key, setting_value FROM settings")->fetchAll(PDO::FETCH_KEY_PAIR);
    $academic_session = $settings['academic_session'] ?? '2025-2026';
} catch (PDOException $e) {
    die("Could not fetch required data.");
}

// Define the months of a typical academic session
$academic_months = [
    '04' => 'April', '05' => 'May', '06' => 'June', '07' => 'July', '08' => 'August', '09' => 'September',
    '10' => 'October', '11' => 'November', '12' => 'December', '01' => 'January', '02' => 'February', '03' => 'March'
];
?>

<div class="content-header">
    <h1>Bulk Fee Assignment</h1>
    <p>Generate monthly fees for an entire session for a class.</p>
</div>

<!-- Message Display Area -->
<?php if(isset($_GET['success'])): ?><div class="alert alert-success"><?php echo htmlspecialchars($_GET['success']); ?></div><?php endif; ?>
<?php if(isset($_GET['error'])): ?><div class="alert alert-danger"><?php echo htmlspecialchars($_GET['error']); ?></div><?php endif; ?>

<div class="card">
    <div class="card-body">
        <form action="process_bulk_assignment.php" method="POST" onsubmit="return confirm('Are you sure you want to generate fees for all selected months? This cannot be easily undone.');">
            
            <div class="form-group" style="padding:0 10px;">
                <label>1. Select Class</label>
                <select name="class_id" required>
                    <option value="">-- Choose a Class --</option>
                    <?php foreach($classes as $class): ?>
                    <option value="<?php echo $class['class_id']; ?>"><?php echo htmlspecialchars($class['class_name'] . ' - ' . $class['section']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-group" style="padding:0 10px;">
                <label>2. Select Months to Assign Fees (Session: <?php echo $academic_session; ?>)</label>
                <div class="months-grid">
                    <?php foreach($academic_months as $num => $name): ?>
                    <label class="month-checkbox"><input type="checkbox" name="months[]" value="<?php echo $num; ?>" checked> <?php echo $name; ?></label>
                    <?php endforeach; ?>
                </div>
                <button type="button" id="select-all-btn" class="btn" style="margin-top:10px; background-color:#eee;">Select/Deselect All</button>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="assignment_title">3. Base Title for Assignment</label>
                    <input type="text" name="assignment_title" id="assignment_title" value="Monthly Academic Fee" required>
                </div>
                <div class="form-group">
                    <label for="due_day">4. Due Day of Each Month</label>
                    <input type="number" name="due_day" id="due_day" min="1" max="28" value="10" required>
                </div>
            </div>

            <div class="form-footer">
                <button type="submit" class="btn btn-primary">Generate Fees for Selected Months</button>
            </div>
        </form>
    </div>
</div>

<style>
.months-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(120px, 1fr)); gap: 10px; }
.month-checkbox { display: block; padding: 8px; border: 1px solid #ddd; border-radius: 4px; cursor: pointer; }
.month-checkbox:has(input:checked) { background-color: #d4edda; border-color: #c3e6cb;}
</style>

<script>
document.getElementById('select-all-btn').addEventListener('click', function() {
    const checkboxes = document.querySelectorAll('input[name="months[]"]');
    const allChecked = Array.from(checkboxes).every(cb => cb.checked);
    checkboxes.forEach(cb => cb.checked = !allChecked);
});
</script>

<?php require_once 'includes/footer.php'; ?>
